function svglabels( fid, x, y, text, varargin)


% default values
fs = 20;
fill = 'black';
family = 'Arial';
weight = 'normal';

% parameter handling
for argindex=1:2:length(varargin)
  arg=varargin{argindex};
  param=varargin{argindex+1};
  switch(arg)
   case 'font-size'
    fs=param;
   case 'fill'
    fill = param;   
   case 'font-family'
    family = param;
   case 'font-weight'
    weight = param;    
   otherwise
    error(['invalid parameter at position ', mat2str(argindex)]);
  end % switch
end % for argindex


for idx = 1: length( x ),
%     svgline(fid, [min(x), max(idx)], [y(idx), y(idx)],  'stroke', 'black' );
    if length(x) == 1,
        str = text;
    else
        str = text{ idx };
    end
    
    fprintf(fid,  [ '<text xml:space="preserve" x="%f" y="%f" font-family="', family, '" font-weight="', weight, '" font-size="%f" fill="', fill, '" >', str, '</text> \n\r' ], [x(idx), y(idx), fs] );
end

% 
% 
% <text x="250" y="150" 
%         font-family="Verdana" font-size="55" fill="blue" >
%     Hello, out there
%   </text>
